# EG8-14 Kompletny program

# pobranie funkcji wprowadzania liczb 
from BTCInput import *  

# utwórz pustą listę sales
sales=[]

def read_sales(no_of_sales):
    '''
    Odczytuje wartości sprzedaży i zapisuje je 
    na liście sales. 
    Zmienna no_of_sales zawiera liczbę wartości sprzedaży do przechowania
    '''
    # usuń wszystkie poprzednie wartości sprzedaży
    sales.clear()
    # odczytaj wartości sprzedaży 
    for count in range(1, no_of_sales+1):
        # zbuduj ciąg monitu
        prompt = 'Wprowadź wartość sprzedaży dla punktu numer ' + str(count) + ': '
        # odczytaj wartość i dołącz ją do listy sales
        sales.append(read_int(prompt))

def print_sales():
    '''
    Wyświetla na ekranie dane sprzedaży poprzedzone nagłówkiem 
    . Każda wartość jest ponumerowana zgodnie z numerem punktu sprzedaży
    '''
    # wyświetl nagłówek
    print('Wartości sprzedaży')
    # zainicjuj licznik punktów sprzedaży
    count=1
    # przetwarzanie wartości sprzedaży
    for sales_value in sales:
        # wyświetl element
        print('Wartość sprzedaży dla punktu ', count,'wynosi ',sales_value)
        # zwiększenie licznika punktów
        count = count + 1

def sort_high_to_low():
    '''
    Wyświetla listę wartości sprzedaży posortowanych od najwyższej do najniższej
    '''
    for sort_pass in range(0,len(sales)):
        done_swap=False
        for count in range(0,len(sales)-1-sort_pass):
            if sales[count]<sales[count+1]:
                temp=sales[count]
                sales[count]=sales[count+1]
                sales[count+1]=temp
                done_swap=True
        if done_swap==False:
            break
    print_sales()

def sort_low_to_high():
    '''
    Wyświetla listę wartości sprzedaży posortowanych od najwyższej do najniższej
    '''
    for sort_pass in range(0,len(sales)):
        done_swap=False
        for count in range(0,len(sales)-1-sort_pass):
            if sales[count]>sales[count+1]:
                temp=sales[count]
                sales[count]=sales[count+1]
                sales[count+1]=temp
                done_swap=True
        if done_swap==False:
            break
    print_sales()

def highest_and_lowest():
    '''
    Wyświetl największe i najmniejsze wartości sprzedaży
    '''
    highest=sales[0]
    lowest=sales[0]
    for sales_value in sales:
        if sales_value>highest:
            highest=sales_value
        if sales_value<lowest:
            lowest=sales_value
    print('Wartość największa to:', highest)
    print('Wartość najmniejsza to:', lowest)

def total_sales():
    '''
    Wyświetl całkowitą wartość sprzedaży
    '''
    total=0
    for sales_value in sales:
        total = total+sales_value
    print('Całkowita sprzedaż wynosi:', total)

def average_sales():
    '''
    Wyświetl średnią wartość sprzedaży
    '''
    total=0
    for sales_value in sales:
        total = total+sales_value
    average_sales=total/len(sales)
    print('Średnia wartość sprzedaży wynosi:', average_sales)


# Rozpoczęcie od wczytania danych sprzedaży
read_sales(10)

# Pobranie polecenia od użytkownika

menu='''Sprzedaż lodów

1: Wyświetl wartości sprzedaży
2: Sortuj od najwyższej do najniższej
3: Sortuj od najniższej do najwyższej
4: Największa i najmniejsza
5: Sprzedaż całkowita
6: Średnia sprzedaż
7: Wprowadź liczby

Wprowadź polecenie: '''

# Wielokrotnie czytaj polecenia i je realizuj
while True:
    command=read_int_ranged(menu,1,7)
    if command==1:
        print_sales()
    elif command==2:
        sort_high_to_low()
    elif command==3:
        sort_low_to_high()
    elif command==4:
        highest_and_lowest()
    elif command==5:
        total_sales()
    elif command==6:
        average_sales()
    elif command==7:
        read_sales(10)


